/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.cucumber.event.ItemBreakEvent;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentAttributeModifier;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public final class TinkerableHandler {
    @SubscribeEvent
    public void onItemBreak(ItemBreakEvent event) {
        Item item = event.getItem();
        LivingEntity entity = event.getEntity();
        if (item instanceof ITinkerable && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = event.getItemStack();
            List<Augment> augments = AugmentUtils.getAugments(stack);
            for (Augment augment : augments) {
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)augment.getItem()));
            }
        }
    }

    @SubscribeEvent
    public void onItemAttributesModifiers(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof ITinkerable) {
            List<Augment> augments = AugmentUtils.getAugments(stack);
            for (Augment augment : augments) {
                List<AugmentAttributeModifier> modifiers = augment.getAttributeModifiers();
                if (modifiers.isEmpty()) continue;
                for (AugmentAttributeModifier modifier : modifiers) {
                    event.addModifier(modifier.attribute(), modifier.modifier(), modifier.slot());
                }
            }
        }
    }
}

